package kochModel.factory;
import java.awt.geom.Point2D;

/**
 * This class encapsulates an Affine transform.  Specifically, an instance of this class is the Affine transform a point defined on the 
 * unit interval, (0.0,0.0) to (0.0, 1.0),  to an arbitrarily define interval.
 */
class AffineXForm
{
	private Point2D.Double a;
	private Point2D.Double delta;
	/**
	 * The interval to transform to, is loaded into this object in the form of offset and distance.
	 * @param a The offset to the beginning of the interval to transform to.
	 * @param delta The distance from the beginning of the interval to the end of the interval.
	 * @SBGen Constructor assigns a, delta
	 */
	AffineXForm(Point2D.Double a, Point2D.Double delta)
	{
		// SBgen: Assign variables
		this.a = a;
		this.delta = delta;
		// SBgen: End assign
	}



	/**
	 * Takes a single point on the unit interval and transforms it onto the stored interval.
	 * @param v The point to be transformed.
	 * @return The transformed point.
	 */
	Point2D.Double doXForm(Point2D.Double v)
	{
		return new Point2D.Double(delta.x * v.x - delta.y * v.y + a.x, delta.y * v.x + delta.x * v.y + a.y);
	}
}

